﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Kz.GammaTech.Crypto.Digests;
using Kz.GammaTech.Crypto;
using Kz.GammaTech.Crypto.Signers;
using Kz.GammaTech.Signers;
using Kz.GammaTech.CPWrapper;
using System.Runtime.InteropServices;

namespace DigestSign
{
    class Program
    {
        static void Main(string[] args)
        {
            byte[] text = System.Text.Encoding.ASCII.GetBytes("1234567890");
                        
            Gost3411Digest dig = new Gost3411Digest();
            dig.BlockUpdate(text, 0, text.Length);
            byte[] res = new byte[dig.GetDigestSize()];
            dig.DoFinal(res, 0);

            TumarProfile profile = new TumarProfile("profile://FSystem", "");
            GostSigner sign = new GostSigner();
            for (int i = 0; i < profile.key_count; i++)
            {
                if (profile.keys[i].keySpec == CpTumar.AT_SIGNATURE)
                {
                    sign.privatekey = profile.keys[i].Private;
                    break;
                }
            }

   
          
           byte[] sign_b = sign.SignData(System.Text.Encoding.ASCII.GetBytes("123456789"));

            GostSigner ver = new GostSigner();
            ver.publickey = profile.keys[0].Public;
            if (ver.VerifyData(System.Text.Encoding.ASCII.GetBytes("123456789"), sign_b))
            {
                Console.WriteLine("verify math sign ok");
            }
            else
            {
                Console.WriteLine("verify math sign fail");
            }

            Digest sha_dig = new Digest("SHA-1");
            sha_dig.BlockUpdate(text, 0, text.Length);
            byte[] res2 = new byte[sha_dig.GetDigestSize()];
            sha_dig.DoFinal(res2, 0);


            TumarProfile profile2 = new TumarProfile("profile://rsa", "");



            RsaSigner rsa_sign = new RsaSigner("SHA-1");
            for (int i = 0; i < profile2.key_count; i++)
            {
                if (profile2.keys[i].keySpec == CpTumar.AT_SIGNATURE)
                {
                    rsa_sign.privatekey= profile2.keys[i].Private;
                    break;
                }
            }
            byte[] signature_rsa = rsa_sign.SignData(text);

            RsaSigner rsa_ver = new RsaSigner("SHA-1");           
            for (int i = 0; i < profile2.key_count; i++)
            {
                if (profile2.keys[i].keySpec == CpTumar.AT_SIGNATURE)
                {
                    rsa_ver.publickey= profile2.keys[i].Public;
                    break;
                }
            }

            if (rsa_ver.VerifyData(text, signature_rsa))
            {
                Console.WriteLine("verify math sign (rsa) ok");
            }
            else
            {
                Console.WriteLine("verify math sign (rsa) fail");
            }
           
            profile.FreeProfile();
			profile2.FreeProfile();
        }
    }
}
